/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.Updatable;
import technology.rocketjump.undermount.jobs.JobStore;
import technology.rocketjump.undermount.jobs.JobWorkCalculator;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobPriority;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.messaging.types.JobRequestMessage;

public class JobRequestHandler
implements GameContextAware,
Updatable,
Telegraph,
Disposable {
    private final MessageDispatcher messageDispatcher;
    private final JobWorkCalculator jobWorkCalculator;
    private final JobStore jobStore;
    private GameContext gameContext;
    private final Deque<JobRequestMessage> jobRequestQueue = new ArrayDeque<JobRequestMessage>();
    private static final int MAX_POTENTIAL_JOBS_PER_PROFESSION = 7;

    @Inject
    public JobRequestHandler(MessageDispatcher messageDispatcher, JobWorkCalculator jobWorkCalculator, JobStore jobStore) {
        this.messageDispatcher = messageDispatcher;
        this.jobWorkCalculator = jobWorkCalculator;
        this.jobStore = jobStore;
        messageDispatcher.addListener(this, 600);
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, 600);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 600: {
                JobRequestMessage jobRequestMessage = (JobRequestMessage)msg.extraInfo;
                this.jobRequestQueue.addLast(jobRequestMessage);
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    @Override
    public void update(float deltaTime) {
        if (!this.jobRequestQueue.isEmpty()) {
            JobRequestMessage jobRequest = this.jobRequestQueue.pop();
            this.handle(jobRequest);
        }
    }

    private boolean handle(JobRequestMessage jobRequestMessage) {
        ProfessionsComponent professionsComponent = jobRequestMessage.getRequestingEntity().getComponent(ProfessionsComponent.class);
        Vector2 entityWorldPosition = jobRequestMessage.getRequestingEntity().getLocationComponent().getWorldPosition();
        GridPoint2 requesterLocation = new GridPoint2((int)Math.floor(entityWorldPosition.x), (int)Math.floor(entityWorldPosition.y));
        ArrayList<Job> potentialJobs = new ArrayList<Job>();
        for (ProfessionsComponent.QuantifiedProfession professionToFindJobFor : professionsComponent.getByPriority()) {
            Collection<Job> byProfession = this.jobStore.getCollectionByState(JobState.ASSIGNABLE).getByProfession(professionToFindJobFor.getProfession()).values();
            if (byProfession.isEmpty()) continue;
            ArrayList<Job> potentialJobsForThisProfession = new ArrayList<Job>();
            LinkedHashMap jobsByDistanceByPriority = new LinkedHashMap();
            for (JobPriority jobPriority : JobPriority.values()) {
                jobsByDistanceByPriority.put(jobPriority, new TreeMap());
            }
            for (Job currentJob : byProfession) {
                if (currentJob.getAssignedToEntityId() != null) continue;
                float distanceToJob = currentJob.getJobLocation().dst2(requesterLocation);
                ((TreeMap)jobsByDistanceByPriority.get((Object)currentJob.getJobPriority())).put(Float.valueOf(distanceToJob), currentJob);
            }
            for (JobPriority priority : JobPriority.values()) {
                TreeMap jobsByDistance = (TreeMap)jobsByDistanceByPriority.get((Object)priority);
                for (Job job : jobsByDistance.values()) {
                    potentialJobsForThisProfession.add(job);
                    if (potentialJobsForThisProfession.size() < 7) continue;
                    break;
                }
                if (potentialJobsForThisProfession.size() >= 7) break;
            }
            potentialJobs.addAll(potentialJobsForThisProfession);
        }
        jobRequestMessage.getCallback().jobCallback(potentialJobs);
        return true;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.jobRequestQueue.clear();
        this.gameContext = gameContext;
    }

    @Override
    public boolean runWhilePaused() {
        return true;
    }
}

